#pragma once
#include <string>
#ifdef STARFLEETTOOLBOX_EXPORTS
#define BADACKEXCEPT __declspec(dllexport)
#else
#define BADACKEXCEPT __declspec(dllimport)
#endif
using namespace std;

/// <summary>
/// An Exception used when a bad acknowledgment error is detected
/// </summary>
class BADACKEXCEPT BadAcknowledgmentException : exception
{
public:
    /// <summary>
    /// Copy constructor
    /// </summary>
    /// <param name="message">A message pointer to a char</param>
    explicit BadAcknowledgmentException(const char* message)
        : _msg(message) {}
    /// <summary>
    /// Copy constructor
    /// </summary>
    /// <param name="message">A message string</param>
    explicit BadAcknowledgmentException(const string& message)
        : _msg(message) {}

    /// <summary>
    /// Destructor
    /// </summary>
    /// <returns></returns>
    virtual ~BadAcknowledgmentException() noexcept {}

    /// <summary>
    /// Overload of message retrie
    /// </summary>
    /// <returns>A pointer to a char representing the message</returns>
    virtual const char* what() const noexcept {
        return _msg.c_str();
    }    
protected:
    string _msg;    
};

