#pragma once
#include <string>
#ifdef STARFLEETTOOLBOX_EXPORTS
#define COMMEXCEPT __declspec(dllexport)
#else
#define COMMEXCEPT __declspec(dllimport)
#endif
using namespace std;

/// <summary>
/// An Exception used when a communication error is detected
/// </summary>
class COMMEXCEPT CommunicationException : exception
{
public:    
    /// <summary>
    /// Copy constructor
    /// </summary>
    /// <param name="message">A message pointer to a char</param>
    explicit CommunicationException(const char* message)
        : _msg(message) {}
    /// <summary>
    /// Copy constructor
    /// </summary>
    /// <param name="code">The error code</param>
    /// <param name="message">A message string</param>
    explicit CommunicationException(int code, const string& message);

    /// <summary>
    /// Copy constructor
    /// </summary>
    /// <param name="message">A message string</param>
    explicit CommunicationException(const string& message)
        : _msg(message) {}
    
    /// <summary>
    /// Destructor
    /// </summary>
    /// <returns></returns>
    virtual ~CommunicationException() noexcept {}

    /// <summary>
    /// Overload of message retrie
    /// </summary>
    /// <returns>A pointer to a char representing the message</returns>
    virtual const char* what() const noexcept {
        return _msg.c_str();
    }
	
	int GetErrorCode();
protected:
    string _msg;
    int _code = -1;
};

