#pragma once
#include "BaseSettings.h"

#include<string>;


#ifdef STARFLEETTOOLBOX_EXPORTS
#define ETHSETTENCAPS __declspec(dllexport)
#else
#define ETHSETTENCAPS __declspec(dllimport)
#endif


using namespace std;

/// <summary>
/// The ETHERNET settings encapsulation for ETHERNET communication
/// </summary>
class ETHSETTENCAPS EthernetSettings :
    public BaseSettings
{
public:
    /// <summary>
    /// Base constructor
    /// </summary>
    EthernetSettings();

    /// <summary>
    /// Copy constructor
    /// </summary>
    /// <param name="pIp">IP V4 Address</param>
    /// <param name="pTcpPort">TCP Port number</param>
    /// <param name="pUdpPort">UDP Port number</param>
    EthernetSettings(string pIp, int pTcpPort, int pUdpPort);

    /// <summary>
    /// Destructor
    /// </summary>
    ~EthernetSettings();


    /// <summary>
    /// Returns the IP Address
    /// </summary>
    /// <returns>The IP Address represented as a string</returns>
    string GetIp();

    /// <summary>
    /// Gets the TCP Port
    /// </summary>
    /// <returns>The TCP Port represented as an int</returns>
    int GetTcpPort();

    /// <summary>
    /// Gets the UDP Port
    /// </summary>
    /// <returns>The UDP Port represented as an int</returns>
    int GetUdpPort();

    /// <summary>
    /// Sets the IP v4 Address
    /// </summary>
    /// <param name="pIp">The IP v4 address to be set</param>
    void SetIp(string pIp);

    /// <summary>
    /// Sets the TCP Port
    /// </summary>
    /// <param name="pTcpPort">The TCP Port to be set</param>
    void SetTcpPort(int pTcpPort);

    /// <summary>
    /// Sets the UDP Port
    /// </summary>
    /// <param name="pUdpPort">The UDP Port to be set</param>
    void SetUdpPort(int pUdpPort);


private:
    string  _ip;
    int _tcpPort;
    int _udpPort;    
};

