#pragma once
#include <string>
#ifdef STARFLEETTOOLBOX_EXPORTS
#define NOTSUPPOORTEDEXCPT __declspec(dllexport)
#else
#define NOTSUPPOORTEDEXCPT __declspec(dllimport)
#endif
using namespace std;
/// <summary>
/// An exception used when not supported values are fetched to the sensor
/// </summary>
class NOTSUPPOORTEDEXCPT ParameterNotSupportedException : exception
{
public:
    /// <summary>
    /// Copy constructor
    /// </summary>
    /// <param name="message">A message pointer to a char</param>
    explicit ParameterNotSupportedException(const char* message)
        : _msg(message) {}

    /// <summary>
    /// Copy constructor
    /// </summary>
    /// <param name="message">A message string</param>
    explicit ParameterNotSupportedException(const string& message)
        : _msg(message) {}

    /// <summary>
    /// Destructor
    /// </summary>
    /// <returns></returns>
    virtual ~ParameterNotSupportedException() noexcept {}

    /// <summary>
    /// Overload of message retrie
    /// </summary>
    /// <returns>A pointer to a char representing the message</returns>
    virtual const char* what() const noexcept {
        return _msg.c_str();
    }
protected:
    string _msg;
    string _code = "";
};