#pragma once
#ifdef STARFLEETTOOLBOX_EXPORTS
#define SOFTVER __declspec(dllexport)
#else
#define SOFTVER __declspec(dllimport)
#endif
typedef unsigned int PRODUCT_IDENTIFICATION;
#define UNKNOWN_PRODUCT 0
#define RAW_DATA 47
#define ANTI_COLLISION  48
#define NAVIGATION 49
#define ROD_300 30
#define ROD_500 50
#define ROD_120 12
#define ROD_130 13

/// <summary>
/// Helper to encapsulate the software version
/// </summary>
class SOFTVER SoftwareVersion
{
public:
	/// <summary>
	/// Gets the internal software version
	/// </summary>
	/// <returns>The internal software version as an int</returns>
	unsigned int GetVersion();

	/// <summary>
	/// Sets the internal software version
	/// </summary>
	/// <param name="pVersion">The internal software version to be set</param>
	void SetVersion(unsigned int pVersion);

	/// <summary>
	/// Gets the internal software revision
	/// </summary>
	/// <returns>The internal software revision as an int</returns>
	unsigned int GetRevision();

	/// <summary>
	/// Sets the internal software revision
	/// </summary>
	/// <param name="pRevision">The internal software revision to be set</param>
	void SetRevision(unsigned int pRevision);

	/// <summary>
	/// Gets the internal prototype code
	/// </summary>
	/// <returns>The internal prototype code as an int</returns>
	unsigned int GetPrototype();

	/// <summary>
	/// Sets the internal prototype code
	/// </summary>
	/// <param name="pPrototype">The internal prototype code to be set</param>
	void SetPrototype(unsigned int pPrototype);


	/// <summary>
	/// Gets the internal CAN number
	/// </summary>
	/// <returns>The internal CAN number as an long</returns>
	unsigned long GetCanNumber();

	/// <summary>
	/// Sets the internal CAN number
	/// </summary>
	/// <param name="pSerial">The internal CAN number to be set</param>
	void SetCanNumber(unsigned long pCanNumber);

	/// <summary>
	/// Gets the Hardware version
	/// </summary>
	/// <returns>The internal hardware version</returns>
	unsigned int GetHardwareVersion();
	/// <summary>
	/// Sets the Hardware version
	/// </summary>
	/// <param name="pHardwareVersion">The internal hardware version</param>
	void SetHardwareVersion(unsigned int pHardwareVersion);

	/// <summary>
	/// Gets the internal part number
	/// </summary>
	/// <returns>The internal part number as an long</returns>
	unsigned long GetPartNumber();

	/// <summary>
/// Sets the internal part number
/// </summary>
/// <param name="pPartNumber">The internal part number to be set</param>
	void SetPartNumber(unsigned long pPartNumber);

	/// <summary>
	/// Gets the product identification
	/// </summary>
	/// <returns>RAW_DATA, ANTI_COLLISION, NAVIGATION or UNKNOWN_PRODUCT</returns>
	PRODUCT_IDENTIFICATION GetProductIdentification();

	/// <summary>
	/// Sets the product identification
	/// </summary>
	/// <param name="pProductIdentification">Can be RAW_DATA, ANTI_COLLISION, NAVIGATION or UNKNOWN_PRODUCT</param>
	void SetProductIdentification(PRODUCT_IDENTIFICATION pProductIdentification);

private:

	unsigned int _version = 0;
	unsigned int _revision = 0;
	unsigned int _prototype = 0;
	unsigned long _canNumber = 0;
	unsigned int _hardwareVersion = 0;
	unsigned long _part = 0;
	unsigned int _productIdentification = 0;
};



