#pragma once
#include "BaseSettings.h"

#include<string>;

#ifdef STARFLEETTOOLBOX_EXPORTS
#define USBSETTENCAPS __declspec(dllexport)
#else
#define USBSETTENCAPS __declspec(dllimport)
#endif

using namespace std;
/// <summary>
/// The USB settings encapsulation for USB communication
/// </summary>
class USBSETTENCAPS UsbSettings :
    public BaseSettings
{
public:
    /// <summary>
    /// Base constructor
    /// </summary>
    UsbSettings();

    /// <summary>
    /// Copy constructor
    /// </summary>
    /// <param name="vendorId">The hardware vendor identifier</param>
    /// <param name="productId">The hardware product identifier</param>
    /// <param name="writeChannel">The device's channel identifier on which command must be sent</param>
    /// <param name="readChannel">The device's channel identifier on which ackowledgments and raw data will be sent</param>
    UsbSettings(unsigned int vendorId, unsigned int productId, unsigned int readChannel, unsigned int writeChannel);

    /// <summary>
    /// Destructor
    /// </summary>
    ~UsbSettings();

    /// <summary>
    /// Gets the device's vendor identifier
    /// </summary>
    /// <returns>The device's vendor identifier</returns>
    unsigned int GetVendorId();

    /// <summary>
    /// Gets the device's product identifier
    /// </summary>
    /// <returns>The device's product identifier</returns>
    unsigned int GetProductId();

    /// <summary>
    /// Get the device's input channel
    /// </summary>
    /// <returns>The device's input channel</returns>
    unsigned int GetReadChannel();

    /// <summary>
    /// Gets the device output channel
    /// </summary>
    /// <returns>The device's ouput channel</returns>
    unsigned int GetWriteChannel();

    /// <summary>
    /// Sets the device's vendor identifier
    /// </summary>
    /// <param name="vendorId">The device's vendor identifier</param>
    void SetVendorId(unsigned int vendorId);

    /// <summary>
    /// Sets the device's product identifier
    /// </summary>
    /// <param name="vendorId">The device's prodict identifier</param>
    void SetProductId(unsigned int productId);

    /// <summary>
    /// Sets the device's input channel
    /// </summary>
    /// <param name="vendorId">The device's input channel</param>
    void SetReadChannel(unsigned int inputChannel);

    /// <summary>
    /// Sets the device's output channel
    /// </summary>
    /// <param name="vendorId">The device's output channel</param>
    void SetWriteChannel(unsigned int outputChannel);
private:
    unsigned int _vendorId;
    unsigned int _productId;
    unsigned int _readChannel;
    unsigned int _writeChannel;
};

