#pragma once

#ifdef RAWDATASENSOR_EXPORTS
#define AGLRANGE __declspec(dllexport)
#else
#define AGLRANGE __declspec(dllimport)
#endif

/// <summary>
/// Helper to encapsulate the Angle range data
/// </summary>
class AGLRANGE AngleRange
{
public:
	/// <summary>
	/// Gets the start angle
	/// </summary>
	/// <returns>Start angle as int</returns>
	int GetStart();

	/// <summary>
	/// Sets the start angle
	/// </summary>
	/// <param name="pStart">the Start angle to be set</param>
	void SetStart(int pStart);


	/// <summary>
	/// Gets the stop angle
	/// </summary>
	/// <returns>stop angle as int</returns>
	int GetStop();

	/// <summary>
	/// Sets the stop angle
	/// </summary>
	/// <param name="pStop">the Stop angle to be set</param>
	void SetStop(int pStop);

private:
	int _start = 0;
	int _stop = 0;
};

