#pragma once
#ifdef RAWDATASENSOR_EXPORTS
#define CONTSTATUS __declspec(dllexport)
#else
#define CONTSTATUS __declspec(dllimport)
#endif

/// <summary>
/// Helper to encapsulate the contamination threshold
/// </summary>
class CONTSTATUS ContaminationStatus
{
public:
	/// <summary>
	/// Gets the contamination status on sensor's left side
	/// </summary>
	/// <returns>Left side contamination as an unsigned int</returns>
	unsigned int GetDataLeft();

	/// <summary>
	/// Sets the contamination status on sensor's left side 
	/// </summary>
	/// <param name="pDataLeft">Left side contamination as an unsigned int</param>
	void SetDataLeft(unsigned int pDataLeft);

	/// <summary>
	/// Gets the contamination status on sensor's middle side
	/// </summary>
	/// <returns>Middle side contamination as an unsigned int</returns>
	unsigned int GetDataMiddle();

	/// <summary>
	/// Sets the contamination status on sensor's middle side 
	/// </summary>
	/// <param name="pDataMiddle">Middle side contamination as an unsigned int</param>
	void SetDataMiddle(unsigned int pDataMiddle);

	/// <summary>
	/// Gets the contamination status on sensor's right side
	/// </summary>
	/// <returns>Right side contamination as an unsigned int</returns>
	unsigned int GetDataRight();

	/// <summary>
	/// Sets the contamination status on sensor's right side 
	/// </summary>
	/// <param name="pDataRight">Right side contamination as an unsigned int</param>
	void SetDataRight(unsigned int pDataRight);

	/// <summary>
	/// Gets the Navigation sensor's Z1 contamination state
	/// </summary>
	/// <returns>Z1 Contamination state</returns>
	unsigned int GetZ1();

	/// <summary>
	/// Sets the Navigation sensor's Z1 contamination state
	/// </summary>
	/// <param name="pZ1">Z1 Navigation sensor's Z1 contamination state</param>
	void SetZ1(unsigned int pZ1);

	/// <summary>
	/// Gets the Navigation sensor's Z2 contamination state
	/// </summary>
	/// <returns>Z2 Contamination state</returns>
	unsigned int GetZ2();

	/// <summary>
	/// Sets the Navigation sensor's Z2 contamination state
	/// </summary>
	/// <param name="pZ2">Z2 Navigation sensor's Z2 contamination state</param>
	void SetZ2(unsigned int pZ2);

	/// <summary>
	/// Gets the Navigation sensor's Z3 contamination state
	/// </summary>
	/// <returns>Z3 Contamination state</returns>
	unsigned int GetZ3();

	/// <summary>
	/// Sets the Navigation sensor's Z3 contamination state
	/// </summary>
	/// <param name="pZ3">Z3 Navigation sensor's Z3 contamination state</param>
	void SetZ3(unsigned int pZ3);

	/// <summary>
	/// Gets the Navigation sensor's Z4 contamination state
	/// </summary>
	/// <returns>Z4 Contamination state</returns>
	unsigned int GetZ4();

	/// <summary>
	/// Sets the Navigation sensor's Z4 contamination state
	/// </summary>
	/// <param name="pZ4">Z4 Navigation sensor's Z4 contamination state</param>
	void SetZ4(unsigned int pZ4);

	/// <summary>
	/// Gets the Navigation sensor's Z5 contamination state
	/// </summary>
	/// <returns>Z5 Contamination state</returns>
	unsigned int GetZ5();

	/// <summary>
	/// Sets the Navigation sensor's Z5 contamination state
	/// </summary>
	/// <param name="pZ5">Z5 Navigation sensor's Z5 contamination state</param>
	void SetZ5(unsigned int pZ5);


	/// <summary>
	/// Gets the Navigation sensor's Z6 contamination state
	/// </summary>
	/// <returns>Z6 Contamination state</returns>
	unsigned int GetZ6();

	/// <summary>
	/// Sets the Navigation sensor's Z6 contamination state
	/// </summary>
	/// <param name="pZ6">Z6 Navigation sensor's Z6 contamination state</param>
	void SetZ6(unsigned int pZ6);


private:
	unsigned int _dataLeft = 0;
	unsigned int _dataMiddle = 0;
	unsigned int _dataRight = 0;

	unsigned int _z1 = 0;
	unsigned int _z2 = 0;
	unsigned int _z3 = 0;
	unsigned int _z4 = 0;
	unsigned int _z5 = 0;
	unsigned int _z6 = 0;
};

