#pragma once
#ifdef RAWDATASENSOR_EXPORTS
#define SENSLED __declspec(dllexport)
#else
#define SENSLED __declspec(dllimport)
#endif
/// <summary>
/// Helper to encapsulate the sensor leds state
/// </summary>
class SENSLED SensorLeds
{

public:
	/// <summary>
	/// Base constructor
	/// </summary>
	SensorLeds();

	/// <summary>
	/// Copy constructor
	/// </summary>
	/// <param name="pStatusLed">Stauts led as abool</param>
	/// <param name="pLogoLed">Logo led as a bool</param>
	SensorLeds(bool pStatusLed, bool pLogoLed);

	/// <summary>
	/// Gets the status led
	/// </summary>
	/// <returns>Status led as a bool (true: ON, false: OFF)</returns>
	bool GetStatusLed();

	/// <summary>
	/// Sets the status led
	/// </summary>
	/// <param name="pStatusLed">The status led to be set (true: ON, false: OFF)</param>
	void SetStatusLed(bool pStatusLed);

	/// <summary>
	/// Gets the logo led
	/// </summary>
	/// <returns>Logo led as a bool (true: ON, false: OFF)</returns>
	bool GetLogoLed();

	/// <summary>
	/// Sets the loogo led
	/// </summary>
	/// <param name="pStatusLed">The logo led to be set (true: ON, false: OFF)</param>
	void SetLogoLed(bool pLogoLed);

private:
	bool _statusLed = false;
	bool _logoLed = false;
};

