#pragma once

#include <iostream>
#include <fstream>
#include <thread>

#include "includes/Toolbox/BaseCommunication.h";
#include "includes/Toolbox/EthernetCommunication.h"
#include "includes/Toolbox/UsbCommunication.h"
#include "includes/Visioscan/RawDataSensor.h"
#include "includes/Toolbox/CommunicationException.h"
#include "includes/Toolbox/FileDataRecorder.h"
#include "includes/Visioscan/SensorLamps.h"

/// Comment this line if you want to use USB connection mode
#define ETHERNET

using namespace std;
/// <summary>
/// SensorDemo shows how to use the VisioscanSet SDK distributed with each Visioscanset sensor (except Anticollision sensor)
/// </summary>
class SensorDemo
{
public:
	/// <summary>
	/// Destructor
	/// </summary>
	~SensorDemo();

	/// <summary>
	/// Connects to the sensor
	/// </summary>
	void Connect();

	/// <summary>
	/// Disconnects from the sensor
	/// </summary>
	void Disconnect();

	/// <summary>
	/// Displays the senor's version
	/// </summary>
	void DisplaySensorVersion();

	/// <summary>
	/// Starts the MDI data collection from sensor
	/// </summary>
	void StartMdi();

	/// <summary>
	/// Stops the MDI data collection from sensor
	/// </summary>
	void StopMdi();

	/// <summary>
	/// Reads the raw data from the sensor in a synchronous mode
	/// </summary>
	/// <param name="count"></param>
	void ReadRawDataSync(int count);

	/// <summary>
	/// Reads the raw data from the sensor in a asynchronous mode
	/// </summary>
	/// <param name="count"></param>
	void ReadRawDataAsync(int count);

	/// <summary>
	/// Operates the miscelaneous recorder function
	/// </summary>
	void OperateRecorder();

	/// <summary>
	/// Manages the sensor's settings
	/// </summary>
	void SettingsManagement();

	/// <summary>
	/// Change the ip of the sensor
	/// </summary>
	void ChangeNetworkSettings();
private:	
	/// <summary>
	/// Basic communication settings
	/// </summary>
	BaseSettings* commSettings;

	/// <summary>
	/// Basic communication mode
	/// </summary>
	BaseCommunication* communication;

	/// <summary>
	/// Rawdata sensor's instance
	/// </summary>
	RawDataSensor* mySensor;
	
	/// <summary>
	/// Utility to write data to a file
	/// </summary>
	/// <param name="toWrite"></param>
	void WriteDataToFile(RawData toWrite);

	/// <summary>
	/// Utility to display the lamps states on the screen
	/// </summary>
	/// <param name="lamps"></param>
	void DisplayLamp(SensorLamps lamps);

	/// <summary>
	/// Miscelaneous variables
	/// </summary>
	bool StopRawDataRead = false;		// Stops the thread for raw data collection
	string ip = "";						// Current IP adress of the sensor
	int port = -1;						// Current port adress of the sensor
};

