#pragma once
#include <vector>
#include <string>
#include "RawData.h"
using namespace std;

#ifdef STARFLEETTOOLBOX_EXPORTS
#define BASEEXTRACT __declspec(dllexport)
#else
#define BASEEXTRACT __declspec(dllimport)
#endif



/// <summary>
/// A basic data extractor used by the communication classes to know HOW to extract
/// RAW data from a stream.
/// </summary>
class BASEEXTRACT BaseDataExtractor  abstract
{
public:
	/// <summary>
	/// Pure virtual method that will help the caller to extract the
	/// rawdata from a stream
	/// </summary>
	/// <param name="pDataToExtract">A vector representing the data frames</param>
	/// <returns>A Raw Data object</returns>
	virtual RawData ExtractData(vector<string>pDataToExtract) = 0;

	/// <summary>
	/// Pure virtual method that will help the caller to discriminate rawdata header from
	/// acknowledgment command data
	/// </summary>
	/// <param name="pDataToVerify">A string representing the stream result</param>
	/// <returns>true if the stream result is an acknowledgment</returns>
	virtual bool IsCommandAcknowledgment(string pDataToVerify) = 0;

	/// <summary>
	/// Pure virtual method that will thel the caller to check if the packet is
	/// a BEA Header
	/// </summary>
	/// <param name="pDataToVerify">A string representing the stream packet</param>
	/// <returns>true if the stream packet is a Header</returns>
	virtual bool IsHeader(string pDataToVerify) = 0;

	/// <summary>
	/// Pure virtual method that will help the caller to check if stream packet
	/// is the end of stream
	/// </summary>
	/// <param name="pDataToVerify">A string representing the setream packet</param>
	/// <returns>true if the stream packet is the end of packet</returns>
	virtual bool IsEndOfPacket(string pDataToVerify) = 0;

	/// <summary>
		/// Pure virtual method that will help the caller to check if stream packet
		/// is the first packet of stream
		/// </summary>
		/// <param name="pDataToVerify">A string representing the setream packet</param>
		/// <returns>true if the stream packet is the first packet</returns>
	virtual bool IsFirstPacket(string pDataToVerify) = 0;

	/// <summary>
	/// Returns a pointer on an array with a determined size
	/// </summary>
	/// <returns>A char array</returns>
	virtual int GetPacketHeaderSizeToRead() = 0;

	/// <summary>
	/// Indicates how much byte must be read in order to obtain packet len
	/// </summary>
	/// <returns>An integer representing the amount of bytes to read</returns>
	virtual int CountToReadForLength(char* pHeaderBuffer) = 0;

	/// <summary>
	/// Retrieve, in the pLenHeaderBuffer, the amount of data to read
	/// </summary>
	/// <param name="pLenHeaderBuffer"></param>
	/// <param name="pPacketType"></param>
	/// <returns>The amount of data to read</returns>
	virtual int GetPacketLengthToRead(char* pLenHeaderBuffer, int pPacketType) = 0;
};

