#pragma once
#include <string>
#include "RawData.h"
#include "Utility.h"

#ifdef STARFLEETTOOLBOX_EXPORTS
#define BASEDATARECORDER __declspec(dllexport)
#else
#define BASEDATARECORDER __declspec(dllimport)
#endif
using namespace std;

class BASEDATARECORDER BaseDataRecorder	abstract
{
public:
	static const int STOPPED = 0;
	static const int PLAYING = 1;
	static const int RECORDING = 2;
	static const int FAILED_START_RECORDING = 3;
	static const int FAILED_INITIALIZE = 4;
	static const int PAUSED = 5;
	/// <summary>
	/// Base constructor
	/// </summary>
	BaseDataRecorder();

	/// <summary>
	/// Destructor
	/// </summary>
	~BaseDataRecorder();

	/// <summary>
	/// Returns the recorder's status (STOPPED, PLAYING, RECORDING)
	/// </summary>
	/// <returns>A integer expression</returns>
	virtual int GetStatus() = 0;

	/// <summary>
	/// Plays a record from the file
	/// </summary>
	virtual void Play() = 0;

	/// <summary>
	/// Pause the playback
	/// </summary>
	virtual void Pause() = 0;

	/// <summary>
	/// Stops either playing or recording
	/// </summary>
	virtual void Stop() = 0;

	/// <summary>
	/// Start recording data
	/// </summary>
	virtual void Record() = 0;

	/// <summary>
	/// Exports record file to CSV only if recorder is in STOP mode
	/// </summary>
	/// <param name="pPathToExport">The fulle filepath name to export the data</param>
	virtual void ExportToCsv(string pPathToExport, MEASURMENT_UNIT pMeasurmentSystem) = 0;

	/// <summary>
	/// Records RawData in the file (internal usage only)
	/// </summary>
	/// <param name="data">The rawdata to be recorded</param>
	virtual void FetchRecord(RawData data) = 0;


	/// <summary>
	/// Wait for a data comming from the player
	/// </summary>
	/// <returns>The replayed data</returns>
	virtual RawData WaitForRawData() = 0;

	/// <summary>
	/// Sets the framerate (thread safe)
	/// </summary>
	/// <param name="pFrameRate">an integer representing the framerate</param>
	void SetFrameRate(int pFrameRate);

	/// <summary>
	/// Gets the current framerate (thread safe)
	/// </summary>
	/// <returns></returns>
	int GetFrameRate();

	/// <summary>
	/// Returns the total frames contained in the record
	/// </summary>
	/// <returns></returns>
	long GetTotalFrame();

	/// <summary>
	/// Returns the actual frame position in the record whilm being played
	/// </summary>
	/// <returns></returns>
	long GetCurrentFramePosition();
protected:
	/// <summary>
	/// Sets the total frame of the record
	/// </summary>
	/// <param name="pTotalFrame">The total frame</param>
	void SetTotalFrame(long pTotalFrame);

	/// <summary>
	/// Sets the current frame being read
	/// </summary>
	/// <param name="pCurrentFramePosition">The current frame position</param>
	void SetCurrentFramePosition(long pCurrentFramePosition);
private:
	int _frameRate = 24;
	void* _mutexFrameRate;			// protects the framerate data from concurent changes

	void* _mutexFramePosition;
	void* _mutexTotalFrame;
	long _currentFrame;
	long _totalFrame;
};

