#pragma once
#include <string>
#include <vector>
#ifdef STARFLEETTOOLBOX_EXPORTS
#define CONFRES __declspec(dllexport)
#else
#define CONFRES __declspec(dllimport)
#endif

using namespace std;
/// <summary>
/// Helper to encapsulate the configuration result
/// </summary>
class CONFRES ConfigurationResult
{
public:
	/// <summary>
	/// Base constructor
	/// </summary>
	ConfigurationResult();

	/// <summary>
	/// Copy constructor
	/// </summary>
	/// <param name="pResult">The result to be set</param>
	ConfigurationResult(bool pResult);

	/// <summary>
	/// Sets the result
	/// </summary>
	/// <param name="pResult">The result to be set</param>
	void SetResult(bool pResult);

	/// <summary>
	/// Gets the result
	/// </summary>
	/// <returns>The result as an int</returns>
	bool GetResult();

	/// <summary>
	/// Gets the reason of failure
	/// </summary>
	/// <returns>The reasons as a vector of strings</returns>
	vector<string> GetReasons();

	/// <summary>
	/// Push a reason into the internal reasons vector
	/// </summary>
	/// <param name="reason">The reason to be pushed</param>
	void PushReason(string reason);

private:
	
	bool _result = false;
	vector<string>  _reasons;
};

