#pragma once
#include<string>
#include <vector>
#include <queue>
#include <iostream>
#include <fstream>
#include <thread>
#include "BaseDataRecorder.h"
#include "RawData.h"
#include "Utility.h"

using namespace std;

#ifdef STARFLEETTOOLBOX_EXPORTS
#define FILEDATARECORDER __declspec(dllexport)
#else
#define FILEDATARECORDER __declspec(dllimport)
#endif

class FILEDATARECORDER FileDataRecorder :
    public BaseDataRecorder
{
public:
    /// <summary>
    /// Copy constructor
    /// </summary>
    /// <param name="pPath"></param>
    FileDataRecorder(string pPath);
    ~FileDataRecorder();

	/// <summary>
	/// Returns the recorder's status (STOPPED, PLAYING, RECORDING) (thread safe)
	/// </summary>
	/// <returns>A integer expression</returns>
	int GetStatus();

	/// <summary>
	/// Plays a record from the file
	/// </summary>
	void Play();

	/// <summary>
	/// Pause the playback
	/// </summary>
	void Pause();

	/// <summary>
	/// Stops either playing or recording
	/// </summary>
	void Stop();

	/// <summary>
	/// Start recording data
	/// </summary>
	void Record();

	/// <summary>
	/// Exports record file to CSV only if recorder is in STOP mode
	/// </summary>
	/// <param name="pPathToExport">The full filepath name to export the data</param>
	/// <param name="pMeasurmentSystem">The measurment system (MILLIMETERS or INCHES) to be used to export</param>
	void ExportToCsv(string pPathToExport, MEASURMENT_UNIT pMeasurmentSystem);

	/// <summary>
	/// Records RawData in the file (internal usage only)
	/// </summary>
	/// <param name="data">The rawdata to be recorded</param>
	void FetchRecord(RawData data);


	/// <summary>
	/// Wait for a data comming from the player
	/// </summary>
	/// <returns>The replayed data</returns>
	RawData WaitForRawData();
private:
	const int TOTAL_FRAME = 0;
	const int FRAME_RATE = 1;
	/// <summary>
	/// Sets the status of recorder (thread safe)
	/// </summary>
	/// <param name="pStatus"></param>
	void SetStatus(int pStatus);
	string _filePath;
	int _recorderStatus;					// the internal recorder status	
	vector<RawData> _rawDataVector;

	
	HANDLE _mutexRecorderStatus;			// protects the MDI Record data queue from multi process access
	HANDLE _semPlayer;			// semaphore to warn that RAW Data are available

	ifstream inputFile;
};

