#pragma once

#ifdef STARFLEETTOOLBOX_EXPORTS
#define RAWDATAENCAPS __declspec(dllexport)
#else
#define RAWDATAENCAPS __declspec(dllimport)
#endif


/// <summary>
/// The base class encapsulating sensor's RAW data
/// </summary>
class RAWDATAENCAPS RawData
{
public:
	/// <summary>
	/// The index of the record starting from 1 (FREE the pointer after usage !!!)
	/// </summary>
	int* _indexes = NULL;
	/// <summary>
	/// The reading timestamps elapsed from the StartMdi command expressed in nanoseconds (FREE the pointer after usage !!!)
	/// </summary>
	double* _timestamps = NULL;
	/// <summary>
	/// Distances array (FREE the pointer after usage !!!)
	/// </summary>
	double* _distances = NULL;
	/// <summary>
	/// Intensities array (FREE the pointer after usage !!!)
	/// </summary>
	double* _intensities = NULL;
	/// <summary>
	/// Angles array (FREE the pointer after usage !!!)
	/// </summary>
	double* _angles = NULL;
	/// <summary>
	/// Scan counts
	/// </summary>
	int _scanCount = 0;
	/// <summary>
	/// The frame rate (can be used by a recorder for replay purpose)
	/// </summary>
	int _frameRate = 0;
};

