#pragma once
#include <string>
#include "TranscribableException.h"
#ifdef STARFLEETTOOLBOX_EXPORTS
#define SENSORERROREXCPT __declspec(dllexport)
#else
#define SENSORERROREXCPT __declspec(dllimport)
#endif
using namespace std;
/// <summary>
/// An exception used when the sensor returns an error related to a command excecution
/// </summary>
class SENSORERROREXCPT SensorErrorException : exception, public TranscribableException
{
public:
    /// <summary>
    /// Copy constructor
    /// </summary>
    /// <param name="message">A message pointer to a char</param>
    explicit SensorErrorException(const char* message, const char* translateCode)
        : _msg(message) {
        SetTranslateCode(string(translateCode));
    }
    /// <summary>
    /// Copy constructor
    /// </summary>
    /// <param name="code">The error code</param>
    /// <param name="message">A message string</param>
    explicit SensorErrorException(string code, const string& message, string translateCode);

    /// <summary>
    /// Copy constructor
    /// </summary>
    /// <param name="message">A message string</param>
    explicit SensorErrorException(const string& message, string translateCode)
        : _msg(message) {
        SetTranslateCode(translateCode);
    }

    /// <summary>
    /// Destructor
    /// </summary>
    /// <returns></returns>
    virtual ~SensorErrorException() noexcept {}

    /// <summary>
    /// Overload of message retrie
    /// </summary>
    /// <returns>A pointer to a char representing the message</returns>
    virtual const char* what() const noexcept {
        return _msg.c_str();
    }

    string GetErrorCode();
protected:
    string _msg;
    string _code = "";
};