#pragma once
#include "TranscribableException.h"
#include <string>
#ifdef STARFLEETTOOLBOX_EXPORTS
#define THREADEXCEPT __declspec(dllexport)
#else
#define THREADEXCEPT __declspec(dllimport)
#endif

using namespace std;

/// <summary>
/// An Exception used when a thread creation error is detected
/// </summary>
class THREADEXCEPT ThreadCreationException: exception, public TranscribableException
{
public:
	/// <summary>
	/// Copy constructor
	/// </summary>
	/// <param name="message">A message pointer to a char</param>
	explicit ThreadCreationException(const char* message, const char* translateCode)
		: _msg(message) {
		SetTranslateCode(string(translateCode));
	}

	/// <summary>
	/// Copy constructor
	/// </summary>
	/// <param name="message">A message string to a char</param>
	explicit ThreadCreationException(const string& message, string translateCode)
		: _msg(message) {
		SetTranslateCode(translateCode);
	}

	/// <summary>
	/// Copy constructor
	/// </summary>
	/// <param name=""></param>
	/// <returns></returns>
	ThreadCreationException(ThreadCreationException const&) noexcept = default;

	/// <summary>
	/// Assignation operator
	/// </summary>
	/// <param name=""></param>
	/// <returns></returns>
	ThreadCreationException& operator=(ThreadCreationException const&) noexcept = default;
	~ThreadCreationException() override = default;

	/// <summary>
	/// Overload of message retrie
	/// </summary>
	/// <returns>A pointer to a char representing the message</returns>
	const char* what() const noexcept override { return _msg.c_str(); }
private:
	const string _msg;
};

