#pragma once
#include <string>
#include <vector>
#ifdef STARFLEETTOOLBOX_EXPORTS
#define UTILS __declspec(dllexport)
#else
#define UTILS __declspec(dllimport)
#endif


using namespace std;

#define MILLIMETERS 0
#define INCHES 1

typedef int MEASURMENT_UNIT;

/// <summary>
/// Common utility class
/// </summary>
class UTILS Utility
{
public: 
	/// <summary>
	/// Converts milimeters to inches
	/// </summary>
	/// <param name="metricMilimeters">The value in milimeters</param>
	/// <returns>A double representing the conversion to inches</returns>
	static double ToInches(double metricMilimeters);

	/// <summary>
	/// Converts inches to milimeters
	/// </summary>
	/// <param name="imperialInches">The value in milimeters</param>
	/// <returns>A double representing the conversion to milimeters</returns>
	static double ToMilimeters(double imperialInches);

	/// <summary>
	/// Computes a string to 16bit int
	/// </summary>
	/// <param name="recvBuffer">The buffer to converted</param>
	/// <returns>a 16bit int structure</returns>
	static int16_t be16_to_cpu_signed(string recvBuffer);

	/// <summary>
	/// Computes a char to 16bit int
	/// </summary>
	/// <param name="recvChar">The char to be converted</param>
	/// <returns>a 16bit int structure</returns>
	static int16_t be16_to_cpu_signed(char recvChar);

	/// <summary>
	/// Computes a char combinaison to 16bit int
	/// </summary>
	/// <param name="high">The high bytes of the int</param>
	/// <param name="low">The low bytes of the int</param>
	/// <returns>a 16bit int structure</returns>
	static int16_t be16_to_cpu_signed(char high, char low);

	/// <summary>
	/// Computes a string to unsigned 16bit int
	/// </summary>
	/// <param name="recvBuffer">The buffer to converted</param>
	/// <returns>an 16bit unsigned int structure</returns>
	static uint16_t be16_to_cpu_unsigned(string recvBuffer);

	/// <summary>
	/// Computes a char to unsigned 16bit int
	/// </summary>
	/// <param name="recvChar">The char to be converted</param>
	/// <returns>an unsigned 16bit int structure</returns>
	static uint16_t be16_to_cpu_unsigned(char recvChar);

	/// <summary>
	/// Computes a char combinaison to unsigned 16bit int
	/// </summary>
	/// <param name="high">The high bytes of the int</param>
	/// <param name="low">The low bytes of the int</param>
	/// <returns>an unsigned 16bit int structure</returns>
	static uint16_t be16_to_cpu_unsigned(char high, char low);

	/// <summary>
	/// Replaces all 'from' char to 'to' chars in a string
	/// </summary>
	/// <param name="str">The source string</param>
	/// <param name="from">The string to be replaced</param>
	/// <param name="to">The replacement string</param>
	/// <returns>A copy of the source string with replacement applied</returns>
    static string ReplaceAll(string str, const string& from, const string& to);

	/// <summary>
	/// Split a string base in a delimitor int a strings vector
	/// </summary>
	/// <param name="toSplit">The source string</param>
	/// <param name="delimiter">The delimiter on which the source string has to be splitted</param>
	/// <returns>A vecotr of the splitted string</returns>
	static vector<string> Split(string toSplit, string delimiter);

	/// <summary>
	/// Convert a 8bit integer to a hexadecimal string representaiton
	/// </summary>
	/// <param name="toConvert">the number to convert</param>
	/// <returns>A string representing the hew expression of the converted number</returns>
	static string ConvertToHexRepresentation8(int8_t toConvert);

	/// <summary>
	/// Convert a 16bit integer to a hexadecimal string representaiton
	/// </summary>
	/// <param name="toConvert">the number to convert</param>
	/// <returns>A string representing the hew expression of the converted number</returns>
	static string ConvertToHexRepresentation16(int16_t toConvert);

	/// <summary>
	/// Convert a 32bit integer to a hexadecimal string representaiton
	/// </summary>
	/// <param name="toConvert">the number to convert</param>
	/// <returns>A string representing the hew expression of the converted number</returns>
	static string ConvertToHexRepresentation32(int32_t toConvert);

	/// <summary>
	/// Convert a 64bit integer to a hexadecimal string representaiton
	/// </summary>
	/// <param name="toConvert">the number to convert</param>
	/// <returns>A string representing the hew expression of the converted number</returns>
	static string ConvertToHexRepresentation64(int64_t toConvert);

	/// <summary>
	/// Convert a 1 pos char array to 8bit integer
	/// </summary>
	/// <param name="toConvert">the char array to convert</param>
	/// <returns>The 8 bit integer</returns>
	static int8_t ConvertHexTo8Bit(char* toConvert);

	/// <summary>
	/// Convert a 2 pos char array to 16bit integer
	/// </summary>
	/// <param name="toConvert">the char array to convert</param>
	/// <returns>The 16 bit integer</returns>
	static int16_t ConvertHexTo16Bit(char* toConvert);	

	/// <summary>
	/// Convert a 4 pos char array to 32bit integer
	/// </summary>
	/// <param name="toConvert">the char array to convert</param>
	/// <returns>The 32 bit integer</returns>
	static int32_t ConvertHexTo32Bit(char* toConvert);

	/// <summary>
	/// Convert a 8 pos char array to 64bit integer
	/// </summary>
	/// <param name="toConvert">the char array to convert</param>
	/// <returns>The 64 bit integer</returns>
	static int64_t ConvertHexTo64Bit(char* toConvert);

	/// <summary>
	/// Convert a 1 pos char array to 8bit integer
	/// </summary>
	/// <param name="toConvert">the char array to convert</param>
	/// <returns>The 8 bit integer</returns>
	static uint8_t ConvertHexToUnsigned8Bit(char* toConvert);

	/// <summary>
	/// Convert a 2 pos char array to 16bit unsigned integer
	/// </summary>
	/// <param name="toConvert">the char array to convert</param>
	/// <returns>The 16 bit unsigned integer</returns>
	static uint16_t ConvertHexToUnsigned16Bit(char* toConvert);

	/// <summary>
	/// Convert a 4 pos char array to 32bit unsigned integer
	/// </summary>
	/// <param name="toConvert">the char array to convert</param>
	/// <returns>The 32 bit unsigned integer</returns>
	static uint32_t ConvertHexToUnsigned32Bit(char* toConvert);

	/// <summary>
	/// Convert a 8 pos char array to 64bit unsigned integer
	/// </summary>
	/// <param name="toConvert">the char array to convert</param>
	/// <returns>The 64 bit unsigned integer</returns>
	static uint64_t ConvertHexToUnsigned64Bit(char* toConvert);

	/// <summary>
	/// From 4 chars pointer, rebuild an understable ip v4 adress/gateway/mask 
	/// </summary>
	/// <param name="toFromat"></param>
	/// <returns></returns>
	static string ExtractIpModel(const char* toFormat);

	/// <summary>
	/// From 6 chars pointer, rebuild an understable mac adress
	/// </summary>
	/// <param name="toFromat"></param>
	/// <returns></returns>
	static string ExtractMacModel(const char* toFormat);

	/// <summary>
	/// Trim a string to leave 1 decimal char removing extra zeros
	/// </summary>
	/// <param name="toClean">The string to be trimmed</param>
	/// <returns>The trimmed string</returns>
	static string  RemoveTrailingZeros(std::string toClean);
};

