#pragma once
#ifdef RAWDATASENSOR_EXPORTS
#define CONTTHRES __declspec(dllexport)
#else
#define CONTTHRES __declspec(dllimport)
#endif

/// <summary>
/// Helper to encapsulate the contamination threshold
/// </summary>
class CONTTHRES ContaminationThreshold
{
public:
	/// <summary>
	/// Gets the warning status
	/// </summary>
	/// <returns>Warning status as an int</returns>
	unsigned int GetWarning();

	/// <summary>
	/// Sets the warnint staus
	/// </summary>
	/// <param name="pWarning">The warning status to be set</param>
	void SetWarning(unsigned int pWarning);

	/// <summary>
	/// Gets the error status
	/// </summary>
	/// <returns>Error status as an int</returns>
	unsigned int GetError();

	/// <summary>
	/// Sets the error status
	/// </summary>
	/// <param name="pError">The error status to be set</param>
	void SetError(unsigned int pError);
private:
	unsigned int _warning = 0;
	unsigned int _error = 0;
};

