#pragma once


#ifdef NAVIGATIONSENSOR_EXPORTS
#define FILTERTYPE __declspec(dllexport)
#else
#define FILTERTYPE __declspec(dllimport)
#endif

typedef int FILTER_MODE;
#define MEDIAN_FILTER 0
#define AVERAGE_FILTER 1
#define MAX_FILTER 2
#define COMBO_FILTER 3

/// <summary>
/// Helper to encapsulate the the raw data error
/// </summary>
class FILTERTYPE FilterType
{
public:
	/// <summary>
	/// Base constructor
	/// </summary>
	FilterType();

	/// <summary>
	/// Copy constructor
	/// </summary>
	/// <param name="errorDate">the error date as an int</param>
	/// <param name="errorCode">the error code as an int</param>
	FilterType(FILTER_MODE filterType, unsigned int NumH, unsigned int NumS );

	/// <summary>
	/// Gets the filter mode
	/// </summary>
	/// <returns>FILTER_TYPE</returns>
	FILTER_MODE GetFilterMode();

	/// <summary>
	/// Sets the filter mode
	/// </summary>
	/// <param name="filterMode">A value 0, 1, 2</param>
	void SetFilterMode(FILTER_MODE filterMode);

	/// <summary>
	/// Gets historical spots number at current position
	/// </summary>
	/// <returns>unsigned int</returns>
	unsigned int GetNumH();

	/// <summary>
	/// Sets historical spots number at current position
	/// </summary>
	/// <param name="numH">spots number</param>
	void SetNumH(unsigned int numH);

	/// <summary>
	/// Gets historical spots number on both sides
	/// </summary>
	/// <returns></returns>
	unsigned int GetNumS();

	/// <summary>
	/// Sets historical spots number on both sides
	/// </summary>
	/// <param name="numS">spots number</param>
	void SetNumS(unsigned int numS);

private:
	FILTER_MODE _filterMode;
	unsigned int _numH;
	unsigned int _numS;
};

