#pragma once
#include<string>
#ifdef RAWDATASENSOR_EXPORTS
#define NETINFO __declspec(dllexport)
#else
#define NETINFO __declspec(dllimport)
#endif


using namespace std;
/// <summary>
/// Helper to encapsulate the network information
/// </summary>
class NETINFO NetworkInformation
{
public:
	/// <summary>
	/// Gets the IP v4 Address
	/// </summary>
	/// <returns>IP Address as a string</returns>
	string GetIpAddress();

	/// <summary>
	/// Sets the IP v4 Address
	/// </summary>
	/// <param name="pIP">The IP Address v4 to be set</param>
	void SetIpAddress(string pIP);

	/// <summary>
	/// Gets the tcp/ip comm port
	/// </summary>
	/// <returns>TCP Port as an int</returns>
	int GetIpPort();

	/// <summary>
	/// Sets the tcp/ip comm port
	/// </summary>
	/// <param name="pPort">tcp/ip port as an int</param>
	void SetIpPort(int pPort);


	/// <summary>
	/// Gets the gateway Address
	/// </summary>
	/// <returns>Gateway address as a string</returns>
	string GetGateway();

	/// <summary>
	/// Sets the Gateway address
	/// </summary>
	/// <param name="pGateway">The gateway address v4 to be set</param>
	void SetGateway(string pGateway);

	/// <summary>
	/// Gets the subnet mask
	/// </summary>
	/// <returns>Subnet mask as a string</returns>
	string GetSubnetMask();

	/// <summary>
	/// Sets the subnet mask
	/// </summary>
	/// <param name="pSubnetMask">The subnet mask v4 to be set</param>
	void SetSubnetMask(string pSubnetMask);

	/// <summary>
	/// Gets the dhcp mode
	/// </summary>
	/// <returns>dhcp mode as a boolean (true: ON, false: OFF)</returns>
	bool GetDhcpMode();

	/// <summary>
	/// Sets the dhcp mode
	/// </summary>
	/// <param name="pEnabled">The DHCP mode to be set (true: ON, false: OFF)</param>
	void SetDhcpMode(bool pEnabled);

	/// <summary>
	/// Get the sensor's mac adress
	/// </summary>
	/// <returns>The mac adress</returns>
	string GetMacAddress();
		
	/// <summary>
	/// Sets the mac adress field
	/// </summary>
	/// <param name="macAdress">The mac adress to be encapsulated</param>
	void SetMacAddress(string macdAdress);
private:
	string _ipAddress = "";
	int _port = -1;
	string _gateway = "";
	string _mask = "";
	string _macAddress = "";
	bool _dhcp = false;
};

