#pragma once

#ifdef RAWDATASENSOR_EXPORTS
#define ANGLERANGE __declspec(dllexport)
#else
#define ANGLERANGE __declspec(dllimport)
#endif



/// <summary>
/// Helper to encapsulate the the raw data error
/// </summary>
class ANGLERANGE RawDataError
{
public:
	/// <summary>
	/// Base constructor
	/// </summary>
	RawDataError();

	/// <summary>
	/// Copy constructor
	/// </summary>
	/// <param name="errorDate">the error date as an int</param>
	/// <param name="errorCode">the error code as an int</param>
	RawDataError(int errorDate, int errorCode);

	/// <summary>
	/// Gets the error code
	/// </summary>
	/// <returns>Error code as an int</returns>
	int GetErrorCode();

	/// <summary>
	/// Sets the error code
	/// </summary>
	/// <param name="pErrorCode">The error code to be set</param>
	void SetErrorCode(int pErrorCode);

	/// <summary>
	/// Gets the error date
	/// </summary>
	/// <returns>Error date as an int</returns>
	int GetErrorDate();

	/// <summary>
	/// Sets the error date
	/// </summary>
	/// <param name="pErrorDate">The error date to be set</param>
	void SetErrorDate(int pErrorDate);

private:
	int _errorCode = 0;
	int _errorDate = 0;


};

