#pragma once
#ifdef RAWDATASENSOR_EXPORTS
#define SENSLAMP __declspec(dllexport)
#else
#define SENSLAMP __declspec(dllimport)
#endif

#define BLACK 0;
#define RED 1;
#define GREEN 2;
#define ORANGE 3;
#define BLUE 4;

typedef int LEDCOLOR;

/// <summary>
/// Helper to encapsulate the sensor lamps state
/// </summary>
class SENSLAMP SensorLamps
{
public:
	/// <summary>
	/// Base constructor
	/// </summary>
	SensorLamps();

	/// <summary>
	/// Copy constructor
	/// </summary>
	/// <param name="pLed1">the Led1 status as a string</param>
	/// <param name="pLed2">the Led2 status as a string</param>
	/// <param name="pLed3">the Led3 status as a string</param>
	/// <param name="pLed4">the Led4 status as a string</param>
	SensorLamps(LEDCOLOR pLed1, LEDCOLOR pLed2, LEDCOLOR pLed3, LEDCOLOR pLed4);


	/// <summary>
	/// Gets the LED1 status
	/// </summary>
	/// <returns>LED1 status as an int</returns>
	LEDCOLOR GetLed1();

	/// <summary>
	/// Sets the LED1 status
	/// </summary>
	/// <param name="pColor">The led1 color to be set</param>
	void SetLed1(LEDCOLOR pColor);

	/// <summary>
	/// Gets the LED2 status
	/// </summary>
	/// <returns>LED2 status as an int</returns>
	LEDCOLOR GetLed2();

	/// <summary>
	/// Sets the LED status
	/// </summary>
	/// <param name="pColor">The led2 color to be set</param>
	void SetLed2(LEDCOLOR pColor);

	/// <summary>
	/// Gets the LED3 status
	/// </summary>
	/// <returns>LED3 status as an int</returns>
	LEDCOLOR GetLed3();

	/// <summary>
	/// Sets the LED3 status
	/// </summary>
	/// <param name="pColor">The led3 color to be set</param>
	void SetLed3(LEDCOLOR pColor);

	/// <summary>
	/// Gets the LED4 status
	/// </summary>
	/// <returns>LED4 status as an int</returns>
	LEDCOLOR GetLed4();

	/// <summary>
	/// Sets the LED4 status
	/// </summary>
	/// <param name="pColor">The led4 color to be set</param>
	void SetLed4(LEDCOLOR pColor);

private:
	LEDCOLOR _led1 = BLACK;
	LEDCOLOR _led2 = BLACK;
	LEDCOLOR _led3 = BLACK;
	LEDCOLOR _led4 = BLACK;

};

