﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.CompilerServices;
using System.Text;
using System.Threading.Tasks;

namespace VisioscanSetSampleDotNet
{
    internal class VisioscanSetSamples
    {
        public void Run()
        {
            int keyPressed = 0;
            Console.WriteLine("Welcome to the VisioscanSet sample tool!");
            PrintMenu();
            SensorDemo sample = new SensorDemo();
            do
            {
                if (int.TryParse(Console.ReadLine(), out keyPressed))
                {
                    switch (keyPressed)
                    {
                        case 1:
                            // Connect and Disconnect sample
                            sample.Connect();
                            sample.Disconnect();
                            break;
                        case 2:
                            // Display sensor version sample
                            sample.Connect();
                            sample.DisplaySensorVersion();
                            sample.Disconnect();
                            break;
                        case 3:
                            // Starts MDI distribution sample
                            sample.Connect();
                            sample.StartMdi();
                            sample.Disconnect();
                            break;
                        case 4:
                            // Stops MDI distribution sample
                            sample.Connect();
                            sample.StopMdi();
                            sample.Disconnect();
                            break;
                        case 5:
                            // Reads Raw data from the sensor sample (synchronous mode)
                            sample.Connect();
                            sample.ReadRawDataSync(10);
                            sample.Disconnect();
                            break;
                        case 6:
                            // Reads Raw data from the sensor sample (asynchronous mode)
                            sample.Connect();
                            sample.ReadRawDataAsync(10);
                            sample.Disconnect();
                            break;
                        case 7:
                            // Operates the data recorder sample
                            sample.Connect();
                            sample.OperateRecorder();
                            sample.Disconnect();
                            break;
                        case 8:
                            // Manages the settings management sample
                            sample.Connect();
                            sample.SettingsManagement();
                            sample.Disconnect();
                            break;
                        case 9:
                            // Manage the change ip sample
                            sample.Connect();
                            sample.ChangeNetworkSettings();
                            sample.Disconnect();
                            break;
                    }

                    PrintMenu();
                }
            } while (keyPressed != 0);

            Console.WriteLine("Goodbye !");
        }

        private void PrintMenu()
        {
            Console.WriteLine("");
            Console.WriteLine("Please press");
            Console.WriteLine("0 to quit");
            Console.WriteLine("1 to connect disconnect");
            Console.WriteLine("2 to display sensor's version");
            Console.WriteLine("3 to start receiving raw data");
            Console.WriteLine("4 to stop receiving raw data");
            Console.WriteLine("5 to capture raw data (sync)");
            Console.WriteLine("6 to capture raw data (async)");
            Console.WriteLine("7 to operate data recorder");
            Console.WriteLine("8 to get and set sensor's settings");
            Console.WriteLine("9 to change sensor's network settings");
        }
    }
}
