/*
 * Demo functions for VisioscanSet
 * Copyright  2022-2024 Amodei Anthony <aam@bea.be>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */


#include <iostream>
#include <thread>
#include <iostream>
#include <fstream>
#include "includes/Toolbox/BaseCommunication.h";
#include "includes/Toolbox/EthernetCommunication.h"
#include "includes/Toolbox/UsbCommunication.h"
#include "includes/Visioscan/RawDataSensor.h"
#include "SensorDemo.h"

#pragma comment(lib, "Ws2_32.lib")

void PrintMenu();

int main()
{
    int keyPressed = 0;
    cout << "Welcome to the VisioscanSet sample tool!" << endl;
    PrintMenu();
    SensorDemo sample;
    do {        
        cin >> keyPressed;
        switch (keyPressed) {
        case 1:
            // Connect and Disconnect sample
            sample.Connect();
            sample.Disconnect();
            break;
        case 2:
            // Display sensor version sample
            sample.Connect();
            sample.DisplaySensorVersion();
            sample.Disconnect();
            break;
        case 3:            
            // Starts MDI distribution sample
            sample.Connect();
            sample.StartMdi();
            sample.Disconnect();
            break;
        case 4:
            // Stops MDI distribution sample
            sample.Connect();
            sample.StopMdi();            
            sample.Disconnect();
            break;
        case 5:
            // Reads Raw data from the sensor sample (synchronous mode)
            sample.Connect();
            sample.ReadRawDataSync(10);
            sample.Disconnect();
            break;
        case 6:
            // Reads Raw data from the sensor sample (asynchronous mode)
            sample.Connect();
            sample.ReadRawDataAsync(10);
            sample.Disconnect();
            break;
        case 7:
            // Operates the data recorder sample
            sample.Connect();
            sample.OperateRecorder();
            sample.Disconnect();
            break;
        case 8:
            // Manages the settings management sample
            sample.Connect();
            sample.SettingsManagement();
            sample.Disconnect();
            break;
        case 9:
            // Manage the change ip sample
            sample.Connect();
            sample.ChangeNetworkSettings();
            sample.Disconnect();
            break;
        }        
        
        PrintMenu();
    } while (keyPressed != 0);    

    cout << "Goodbye !" << endl;
    exit(1);
}
void PrintMenu() {
    cout << endl;
    cout << "Please press" << endl;
    cout << "0 to quit" << endl;
    cout << "1 to connect disconnect" << endl;
    cout << "2 to display sensor's version" << endl;
    cout << "3 to start receiving raw data" << endl;
    cout << "4 to stop receiving raw data" << endl;
    cout << "5 to capture raw data (sync)" << endl;
    cout << "6 to capture raw data (async)" << endl;
    cout << "7 to operate data recorder" << endl;
    cout << "8 to get and set sensor's settings" << endl;
    cout << "9 to change sensor's network settings" << endl;
}

// Run program: Ctrl + F5 or Debug > Start Without Debugging menu
// Debug program: F5 or Debug > Start Debugging menu

// Tips for Getting Started: 
//   1. Use the Solution Explorer window to add/manage files
//   2. Use the Team Explorer window to connect to source control
//   3. Use the Output window to see build output and other messages
//   4. Use the Error List window to view errors
//   5. Go to Project > Add New Item to create new code files, or Project > Add Existing Item to add existing code files to the project
//   6. In the future, to open this project again, go to File > Open > Project and select the .sln file
